/*
 *  $Id: adaptation.h,v 1.6 2001/03/05 10:03:32 ajung Exp $
 *
 * SCTP implementation according to RFC 2960.
 * Copyright (C) 2000 by Siemens AG, Munich, Germany.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * There are two mailinglists available at http://www.sctp.de which should be
 * used for any discussion related to this implementation.
 *
 * Contact: discussion@sctp.de
 *          Michael.Tuexen@icn.siemens.de
 *          ajung@exp-math.uni-essen.de
 *
 * Purpose: This headerfile defines the interface to the adaption-module.
 *          The adaption-module encapsulates the socket-interface.
 *          The adaption-module also handles timers in the SCTP and its ULP.
 *          .....
 */

/* ############################################################################## */
/* INCLUDES                                                                       */
/* ############################################################################## */

#ifndef ADAPTATION_H
#define ADAPTATION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sctp.h>
#include "globals.h"
#include "distribution.h"


boolean adl_equal_address(union sockunion *one, union sockunion *two);

int adl_str2sockunion(guchar * str, union sockunion *su);

const int adl_sockunion2str(union sockunion *su, guchar * buf, size_t len);




/*------------------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------------------*/

/**
 * This function binds a local socket for incoming requests
 * @return socket file descriptor for the newly opened and bound socket
 * @param address (local) port to bind to
 */
gint adl_open_sctp_socket(int af);

gint adl_get_sctpv4_socket(void);
#ifdef HAVE_IPV6
gint adl_get_sctpv6_socket(void);
#endif


/**
 * function to be called when we get a message from a peer sctp instance in the poll loop
 * @param  sfd the socket file descriptor where data can be read...
 * @param  buf pointer to a buffer, where we data is stored
 * @param  len number of bytes to be sent, including the ip header !
 * @param  address, where data goes from
 * @param	dest_len size of the address
 * @return returns number of bytes actually sent, or error
 */
int adl_send_message(int sfd, void *buf, int len, union sockunion *dest, unsigned char tos);


/**
 * this function initializes the data of this module. It opens raw sockets for
 * capturing SCTP packets, and also opens ICMP sockets, so we can get ICMP events,
 * e.g.  for Path-MTU discovery !
 */
void adl_init_adaptation_layer(void);



/**
 * function add a sfd to the list of sfds we want to wait for with the poll()
 * @param sfd	        the socket file descriptor of the socket to react upon
 * @param scf           function pointer holding the callback funtion for normal events.
 * @return              the current number of sockets that are polled.
 */
int adl_register_socket_cb(gint sfd, sctp_socketCallback scf);


/**
 *	function to close a bound socket from our list of socket descriptors
 *	@param	sfd	socket file descriptor to be closed
 *	@return  0 on success, -1 for error, 1 if socket was not bound
 *    @author  ajung
 */
int adl_remove_cb(gint sfd);

/**
 * remove a sfd from the poll_list, and shift that list to the left
 * @return number of sfd's removed...
 */
int adl_remove_poll_fd(gint sfd);


/**
 * function is to return difference in msecs between time a and b (i.e. a-b)
 * @param a later time (e.g. current time)
 * @param b earlier time
 * @return -1 if a is earlier than b, else msecs that passed from b to a
 */
int adl_timediff_to_msecs(struct timeval *a, struct timeval *b);


void adl_add_msecs_totime(struct timeval *t, unsigned int msecs);

int adl_gettime(struct timeval *tv);


#endif
