/*
 *  $Id: recvctrl.h,v 1.4 2001/03/05 15:23:27 ajung Exp $
 *
 * SCTP implementation according to RFC 2960.
 * Copyright (C) 2000 by Siemens AG, Munich, Germany.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * There are two mailinglists available at http://www.sctp.de which should be
 * used for any discussion related to this implementation.
 *
 * Contact: discussion@sctp.de
 *          Michael.Tuexen@icn.siemens.de
 *          ajung@exp-math.uni-essen.de
 *
 * This module creates SACK data structures, that may be used to
 * indicate received and lost data to the association peer.
 *
 */


#ifndef RECVCTRL_H
#define  RECVCTRL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "globals.h"



#define MAX_SACK_SIZE	1200
#define MAX_SACK_ARRAY_SIZE	1000

void *rxc_new_recvctrl(unsigned int remote_initial_TSN, void* sctpInstance);

void rxc_delete_recvctrl(void *rxc_instance);

/**
 * For now this function treats only one incoming data chunk
 * recvcontrol eventually passes chunk on to stream_engine !
 */
int rxc_data_chunk_rx(SCTP_data_chunk * chunk, unsigned int ad_idx);

/**
 * Function triggered by flowcontrol, tells recvcontrol to create a SACK struct
 * and send it to bundling using bu_put_SACK_Chunk() function.
 * @param  destination_address pointer to address to send sack to  (or null for default)
 * @param  send_at_once, set by timer to send it at once....
 * @return boolean to indicate, whether a SACK was generated, and should be sent !
 */
boolean rxc_create_sack(unsigned int *destination_address, boolean send_at_once);

/**
 * Function triggered by bundling (methinks), in order to signal to
 * rx control that all data chunks have been processed, and a new SACK
 * may be generated
 */
void rxc_all_chunks_processed(void);

/**
 * Function returns the current cumulative TSN, that this association has RECEIVED
 */
unsigned int rxc_read_cummulativeTSNacked();

/**
 * function called by bundling when a SACK is actually sent, to stop
 * a possibly running  timer
 */
void rxc_stop_sack_timer(void);

void rxc_send_sack_everytime(void);
void rxc_send_sack_every_second_time(void);

/**
 * Helper function to get last address on which data arrived
 */
short rxc_read_last_active_address(void);

/**
 * returns my actual buffer size (for now a constant)
 */
unsigned int rxc_get_local_receiver_window(void);

int rxc_get_sack_delay(void);
int rxc_set_sack_delay(unsigned int new_delay);


/**
 * sets my actual buffer size
 */
int rxc_set_local_receiver_window(unsigned int new_window);

void rxc_restart_receivecontrol(unsigned int new_remote_TSN);

#endif
