/*
 *  $Id: reltransfer.h,v 1.3 2001/03/02 18:29:28 ajung Exp $
 *
 * SCTP implementation according to RFC 2960.
 * Copyright (C) 2000 by Siemens AG, Munich, Germany.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * There are two mailinglists available at http://www.sctp.de which should be
 * used for any discussion related to this implementation.
 *
 * Contact: discussion@sctp.de
 *          Michael.Tuexen@icn.siemens.de
 *          ajung@exp-math.uni-essen.de
 *
 * This module implements the retransmission mechanism, and stores
 * all data that has not been acknowledged by the peer.
 *
 */


#ifndef RELTRANSFER_H
#define RELTRANSFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "globals.h"

#define MAX_DEST 	16

typedef struct chunk_data_struct
{
    unsigned int chunk_len;
    unsigned int chunk_tsn;     /* for efficiency */
    unsigned char data[MAX_SCTP_PDU];
    unsigned int gap_reports;
    struct timeval transmission_time;
    /* ack_time : in msecs after transmission time, initially 0, -1 if retransmitted */
    int ack_time;
    unsigned int num_of_transmissions;
    struct timeval lifetime;    /* if time_now is greater than lifetime, chunk may not be sent */
    boolean dontBundle;
    /* array of destinations used to send chunk to, index==num_of_transmissions-1 */
    unsigned int used_destinations[MAX_DEST];
    int initial_destination;
    gpointer context;
} chunk_data;


void *rtx_new_reltransfer(unsigned int number_of_destination_addresses);

void rtx_delete_reltransfer(void *rtx_instance);


/**
 * this is called by bundling, when a SACK needs to be processed
 */
int rtx_process_sack(unsigned int adr_index, void *sack_chunk);

/**
 * TODO : does nothing right now
 * a callback function for initiating retransmission after T3 has elapsed
 */
int rtx_timer_cb(TimerID tid, void *data1, void *data2);

/**
 * a function called by WinFlowCtrl, when chunks have been given to the bundling
 * instance, but need to be kept in the buffer until acknowledged
 * In SDL digram signal is called (RetransChunks)
 *
 * TODO : - add possibility for more than one data_chunk ????
 *
 */
int rtx_save_retrans_chunks(void *data_chunk);

/**
 * a function called by FlowCtrl, when chunk has been given to the bundling
 * instance, but is already contained in the reliable transfer list.
 * some data in that chunks must be updated.
 */
int rtx_update_retrans_chunks(void *data_chunk, unsigned int dest);

/**
 * called from flow-control to trigger retransmission of chunks that have previously
 * been sent to the address that timed out
 */
int rtx_t3_timeout(void *rtx_instance, unsigned int address,
                   unsigned int mtu, chunk_data ** rtx_chunks);



void chunk_list_debug(short event_log_level, List * chunk_list);

/**
 * function to return the last a_rwnd value we got from our peer
 */
unsigned int rtx_read_remote_receiver_window(void);

/**
 * Function returns the number of chunks that are waiting in the queue to be acked
 */
unsigned int rtx_readNumberOfUnackedChunks(void);

/**
 * function to set the a_rwnd value we got from our peer (from INIT/INIT ACK)
 */
int rtx_set_remote_receiver_window(unsigned int new_arwnd);


/**
 * this function returns what we have got as ctsna from the peer
 */
unsigned int rtx_readLocalTSNacked(void);

/**
 * is called, in case we receive a Cookie in the ESTABLISHED state,
 * that indicates the peers restart -> we need to restart too
 */
void rtx_restart_reliable_transfer(void);

/**
 * function that is called by SCTP-Control, when ULP requests
 * shutdown in an established association
 */
int rtx_shutdown(void);


/**
 * function that is called by SCTP-Control, when peer indicates
 * shutdown and sends us his last ctsna...this function dequeues
 * all chunks, and returns the number of chunks left in the queue
 */
unsigned int rtx_rcv_shutdown_ctsna(unsigned int ctsna);


int rtx_sort_tsn(chunk_data * one, chunk_data * two);


#endif
